<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Pengeluaran extends Model
{
    use HasFactory;
    protected $fillable = [
        'rolepengeluaran_id',
        'satuan_id',
        'nm_barang',
        'jml',
        'harga',
    ];

    public function rolepengeluaran(): BelongsTo
    {
        return $this->belongsTo(Rolepengeluaran::class);
    }

    public function satuan(): BelongsTo
    {
        return $this->belongsTo(Satuan::class);
    }
}
